//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ReceiveFileDataFromClient(int Client, char *FileName)
{
    FILE *TargetHandle = NULL;

    char StatusText[255];

    char FullFileName[256];
    sprintf(FullFileName, "%s\\%s\\%s.wpd", DataDirectory, CI[Client].CompanyName, FileName);
    CreateFolderStructure(FullFileName);

    if( (TargetHandle = fopen(FullFileName, "wb")) == NULL)
    {
        sprintf(StatusText, "(%d) Failed to open target file: '%s'.", MyServer.ClientID[Client], FullFileName);
        WriteLog(StatusText);
        return false;
    }

    sprintf(StatusText, "(%d) Receiving client data. %d bytes.", MyServer.ClientID[Client], CI[Client].FileSize);
    WriteLog(StatusText);

    //-------------------------------------------------------------------------
    int DataBufferLen = 0;
	char DataBuffer[MaxReceiveSize + 1];
    DWORD TotalBytesReceived = 0;

	CI[Client].DataCRC = 0xffffffff;

    MyServer.RawMode[Client] = true;

    while(TotalBytesReceived < CI[Client].FileSize && MyServer.Connected[Client])
    {
        if(MyServer.GetReceiveData(Client, DataBuffer, &DataBufferLen))
        {
            CI[Client].DataCRC = PartialCRC(CI[Client].DataCRC, DataBuffer, DataBufferLen);
            TotalBytesReceived = (TotalBytesReceived + DataBufferLen);
            fwrite(DataBuffer, sizeof(char), DataBufferLen, TargetHandle);
        }
        else Sleep(1);
    }
    //-------------------------------------------------------------------------

    MyServer.RawMode[Client] = false;

    CI[Client].DataCRC = (CI[Client].DataCRC ^ 0xffffffff);

    if(TargetHandle) fclose(TargetHandle);
    TargetHandle = NULL;

    if(TotalBytesReceived == CI[Client].FileSize)
    {
        sprintf(StatusText, "(%d) Received %d bytes. Success.", MyServer.ClientID[Client], TotalBytesReceived);
        WriteLog(StatusText);
    }
    else{
        sprintf(StatusText, "(%d) Received %d of %d bytes. Failure.", MyServer.ClientID[Client], TotalBytesReceived, CI[Client].FileSize);
        WriteLog(StatusText);
    }

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define SendNextStatement_SUCCESS 1
#define SendNextStatement_FAILURE 2
#define SendNextStatement_DONE    3

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendNextStatement(int Client)
{
    SQLINTEGER StatementLen = 0;
    SQLCHAR Statement[1024 + 1];
    SQLINTEGER ImportTableLen = 0;
    SQLCHAR ImportTable[32 + 1];
    char StatusText[255];

    char SendData[MaxReceiveSize + 1];

    if(!CI[Client].DBClass.DBFetch(&CI[Client].StatementHandle))
    {
        // This is not an error. It means there are no more rows.
        CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
        return SendNextStatement_DONE;
    }

    if(!CI[Client].DBClass.DBGetData(&CI[Client].StatementHandle, 1, SQL_C_CHAR, Statement, 1024, &StatementLen))
    {
        sprintf(StatusText, "(%d) DBGetData Statement error.", MyServer.ClientID[Client]);
        WriteLog(StatusText);

        CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
        return SendNextStatement_FAILURE;
    }
    if(StatementLen == -1)
	{
	    CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
		return SendNextStatement_FAILURE;
	}

    if(!CI[Client].DBClass.DBGetData(&CI[Client].StatementHandle, 2, SQL_C_CHAR, ImportTable, 32, &ImportTableLen))
    {
        sprintf(StatusText, "(%d) DBGetData ImportTable error.", MyServer.ClientID[Client]);
        WriteLog(StatusText);
        CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
        return SendNextStatement_FAILURE;
    }
    if(StatementLen == -1)
	{
	    CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
		return SendNextStatement_FAILURE;
	}

    sprintf(SendData, "::ImportTable:%s", ImportTable);
    SimpleServerSend(Client, SendData);

    sprintf(SendData, "::Statement:%s", Statement);
    SimpleServerSend(Client, SendData);

    return SendNextStatement_SUCCESS;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ProcessCommand(int Client, char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;
    char FlaggedData[MaxReceiveSize + 1];
    char StatusText[255];

    if(strcmp(ReceivedData, "::RequestFirstStatement") == 0)
    {
        if(!CI[Client].DBClass.DBConnect("{SQL Server}", "Dei-Apps", "sa", "", CI[Client].CompanyDB))
        {
            sprintf(StatusText, "(%d) Error connecting to the web portal customer database.", MyServer.ClientID[Client]);
            WriteLog(StatusText);
            return COMMAND_RESULT_ERROR;
        }

        char Statement[255];
        sprintf(Statement, "SELECT Statement, ImportTable FROM WP_Statements ORDER BY Sequence");

        if(!CI[Client].DBClass.DBExecute(Statement, &CI[Client].StatementHandle))
        {
            sprintf(StatusText, "(%d) DBexecute: RequestFirstStatement Fail.", MyServer.ClientID[Client]);
            WriteLog(StatusText);
            return false;
        }

        int SendResult = SendNextStatement(Client);
        if(SendResult == SendNextStatement_SUCCESS){
            return COMMAND_RESULT_OK;
        }
        else if(SendResult == SendNextStatement_FAILURE){
            SimpleServerSend(Client, "::Error:Server failed to send first statement.");
            return COMMAND_RESULT_ERROR;
        }
        else if(SendResult == SendNextStatement_DONE){
            SimpleServerSend(Client, "::EndOfStatements");
            return COMMAND_RESULT_OK;
        }

        return COMMAND_RESULT_ERROR; // Should never get here
    }
    else if(strcmp(ReceivedData, "::RequestNextStatement") == 0)
    {
        int SendResult = SendNextStatement(Client);
        if(SendResult == SendNextStatement_SUCCESS){
            return COMMAND_RESULT_OK;
        }
        else if(SendResult == SendNextStatement_FAILURE){
            SimpleServerSend(Client, "::Error:Server failed to send next statement.");
            return COMMAND_RESULT_ERROR;
        }
        else if(SendResult == SendNextStatement_DONE){
            SimpleServerSend(Client, "::EndOfStatements");
            return COMMAND_RESULT_OK;
        }

        return COMMAND_RESULT_ERROR; // Should never get here
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::FileName:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        if(ReceiveFileDataFromClient(Client, FlaggedData))
        {
            return COMMAND_RESULT_OK;
        }

        return COMMAND_RESULT_ERROR;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::FileSize:")))
    {
    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        CI[Client].FileSize = atol(FlaggedData);

        return COMMAND_RESULT_OK;
    }

    sprintf(StatusText, "(%d) Received unknown command: %s .", MyServer.ClientID[Client], ReceivedData);
    WriteLog(StatusText);

    return COMMAND_RESULT_UNKNOWN;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

